/**
 * @license
 * Copyright 2019 Google LLC. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

// In the following example, markers appear when the user clicks on the map.
// The markers are stored in an array.
// The user can then click an option to hide, show or delete the markers.
let map: google.maps.Map;
let markers: google.maps.Marker[] = [];

function initMap(): void {

  const lander = { lat: 42.833014, lng: -108.730673 };

  map = new google.maps.Map(document.getElementById("map") as HTMLElement, {
    zoom: 14,
    center: lander,
	mapId: '4504f8b37365c3d0',
  });

  // This event listener will call addMarker() when the map is clicked.
  /*map.addListener("click", (event: google.maps.MapMouseEvent) => {
    addMarker(event.latLng!);
  });*/

  // add event listeners for the buttons
  /*document
    .getElementById("show-markers")!
    .addEventListener("click", showMarkers);
  document
    .getElementById("hide-markers")!
    .addEventListener("click", hideMarkers);
  document
    .getElementById("delete-markers")!
    .addEventListener("click", deleteMarkers);*/
  document
    .getElementById("show-all")!
    .addEventListener("click", function(){
	  deleteMarkers();
	  var pins1 = getPins1();
	  addMarkers1(pins1);
	  var pins2 = getPins2();
	  addMarkers2(pins2);  
	});
  document
    .getElementById("show-sorders")!
    .addEventListener("click", function(){
	  deleteMarkers();
	  var pins1 = getPins1();
	  addMarkers1(pins1);
	});
  document
    .getElementById("show-locates")!
    .addEventListener("click", function(){
	  deleteMarkers();
	  var pins2 = getPins2();
	  addMarkers2(pins2);  
	});

  document.getElementById("show-all").click();
}

function addMarkers1(pins){
  console.log('addMarkers1');
  for(var i in pins){
    var pin = pins[i];
	//console.log(pin);
	var lat = pin['fields']['Latitude'];
	var long = pin['fields']['Longitude'];
	if(lat && long){
	    var position = { lat: parseFloat(lat), lng: parseFloat(long) };
		console.log(position);
		const marker = new google.maps.Marker({
		  position,
		  map,
		});
		markers.push(marker);
	}
  }
}

async function addMarkers2(pins){
  const { AdvancedMarkerElement, PinElement } = await google.maps.importLibrary("marker") as google.maps.MarkerLibrary;

  console.log('addMarkers2');
  for(var i in pins){
    var pin = pins[i];
	//console.log(pin);
	var lat = pin['fields']['Latitude'];
	var long = pin['fields']['Longitude'];
	if(lat && long){
		var position = { lat: parseFloat(lat), lng: parseFloat(long) };
		console.log(position);
		const pinBackground = new PinElement({
		    background: 'yellow',
		});
		const marker = new AdvancedMarkerElement({
		    map,
		    position: position,
		    content: pinBackground.element,
		});
	    markers.push(marker);
	}
  }
}

function getPins1(){
  console.log('getPins1');
  var ret = [];
  
  /* get service orders from airtable.
  1. Service Order Table (Active SO by Street; view):
  https://airtable.com/appTE7fDMy6LA9hVA/tbl9nJri1MA4JWggx/viwJJpUz
  STAeErYOX?blocks=hide
  a. All Service Orders with status: Not Started, Late, In Progress, Delayed/On Hold
  b. Yellow Pins
  */
  var filter = "(";
  filter += "OR({Status} = 'Not Started',{Status} = 'In Progress',{Status} = 'Delayed/On Hold')";
  filter += ")";
  var fields = '';
  //fields += "&fields%5B%5D=recordID";
  //fields += "&fields%5B%5D=Service Address Read Only";
  //fields += "&fields%5B%5D=Service Order Notes Rollup";
  fields += "&fields%5B%5D=Latitude";
  fields += "&fields%5B%5D=Longitude";
  var query = "/Service%20Orders?sort%5B0%5D%5Bfield%5D=Created%20Date%20%26%20Time&sort%5B0%5D%5Bdirection%5D=asc&filterByFormula=" + filter + fields;
  //var query = "/Service%20Orders";
  query = query.replace('%20',' ');
  var url = 'https://api.airtable.com/v0/appTE7fDMy6LA9hVA' + query;
  console.log(url);
  
  let xhr = new XMLHttpRequest();
  xhr.open("GET", url, false);
  xhr.setRequestHeader("Content-Type", "application/json");
  xhr.setRequestHeader("Authorization", "Bearer keydfWgGk9Prjb9LZ");

  try {
    xhr.send();
    if (xhr.status != 200) {
      console.log(`Error ${xhr.status}: ${xhr.statusText}`);
    } else {
      //console.log(xhr.response);
	  var resp = xhr.response;
	  resp = JSON.parse(resp);
	  ret = resp.records || [];
	  //console.log(ret);
    }
  } catch(err) {
    console.log("Request failed");
  }
  
  return(ret);
}

function getPins2(){
  console.log('getPins2');
  var ret = [];
  
  /* get locates from airtable.
  2. Locates Table:
  https://airtable.com/appTE7fDMy6LA9hVA/tblUabXBmJbEErdO5/viwqDx
  LIh2AF1qKWp?blocks=hide
  a. All Locates with status: Not Started, Late, In Progress, Delayed/On Hold
  b. Red Pins
  */
  
  var filter = "(";
  filter += "OR({Status} = 'Not Started',{Status} = 'In Progress',{Status} = 'Delayed/On Hold')";
  filter += ")";
  var fields = '';
  //fields += "&fields%5B%5D=recordID";
  //fields += "&fields%5B%5D=Service Address Read Only";
  //fields += "&fields%5B%5D=Service Order Notes Rollup";
  fields += "&fields%5B%5D=Latitude";
  fields += "&fields%5B%5D=Longitude";
  var query = "/Locates?filterByFormula=" + filter + fields;
  //var query = "/Service%20Orders";
  query = query.replace('%20',' ');
  var url = 'https://api.airtable.com/v0/appTE7fDMy6LA9hVA' + query;
  console.log(url);
  
  let xhr = new XMLHttpRequest();
  xhr.open("GET", url, false);
  xhr.setRequestHeader("Content-Type", "application/json");
  xhr.setRequestHeader("Authorization", "Bearer keydfWgGk9Prjb9LZ");

  try {
    xhr.send();
    if (xhr.status != 200) {
      console.log(`Error ${xhr.status}: ${xhr.statusText}`);
    } else {
      console.log(xhr.response);
	  var resp = xhr.response;
	  resp = JSON.parse(resp);
	  ret = resp.records || [];
	  console.log(ret);
    }
  } catch(err) {
    console.log("Request failed");
  }
  
  return(ret);
}

// Adds a marker to the map and push to the array.
function addMarker(position: google.maps.LatLng | google.maps.LatLngLiteral) {
  const marker = new google.maps.Marker({
    position,
    map,
  });

  markers.push(marker);
}

// Sets the map on all markers in the array.
function setMapOnAll(map: google.maps.Map | null) {
  for (let i = 0; i < markers.length; i++) {
    markers[i].setMap(map);
  }
}

// Removes the markers from the map, but keeps them in the array.
function hideMarkers(): void {
  setMapOnAll(null);
}

// Shows any markers currently in the array.
function showMarkers(): void {
  setMapOnAll(map);
}

// Deletes all markers in the array by removing references to them.
function deleteMarkers(): void {
  hideMarkers();
  markers = [];
}

declare global {
  interface Window {
    initMap: () => void;
  }
}
window.initMap = initMap;
export {};
